import { Router } from 'express';
import { notificationsController } from './controller';
import { authenticateUser } from '@/middlewares/auth';

const router = Router();

// Attach user to req for downstream use
async function attachUser(req: any, res: any, next: any) {
  if (req.user) req.user = req.user;
  next();
}

// List notifications
router.get('/', authenticateUser, attachUser, notificationsController.list);
// Mark as read
router.patch('/:id/read', authenticateUser, attachUser, notificationsController.markAsRead);
// Delete notification
router.delete('/:id', authenticateUser, attachUser, notificationsController.delete);
// Send notification (admin/system)
router.post('/send', authenticateUser, notificationsController.send);

export default router; 